<?php
/*
  This is the second part of mask e-mails addon necessary for "wacko" scope; see
  instructions inside the main script - "mask e-mails.php".

  Note that you don't have to remove this file when changing scope from "wacko" - even
  if this script is left it will work only if scope is set to "wacko".
*/

class Uwacko_MaskEMails extends Uwacko_Base {
  public $htmlTag = 'em';
  public $htmlClasses = array('masked-email');

  function SelfToHtmlWith($contents) {
    return parent::SelfToHtmlWith( $this->Mask($this->startToken, $this->settings->EMailMask) );
  }

    function Mask($email, &$mask) {
      list($user, $domain) = explode('@', $email, 2);

        $rootPos = strrpos($domain, '.');
        $root = substr($domain, $rootPos + 1);
        $domain = substr($domain, 0, $rootPos);

      isset($mask) or $mask = DefaultEMailMask;

      if (in_array( strtolower($mask), array('javascript', 'js') )) {
        $this->htmlTag = null;

        $noscript = @$doc->strings['{{maskemails: javascipt disabled'];
        $noscript or $noscript = 'To see this e-mail you need to have JavaScript enabled'.
                                 ' in your browser.';

        $m = '"<"+"a href=\"mailto:\1" + d, ".\3\" class=\"masked-email\">\1" + d, ".\3<"+"/a>"';
        $script = 'var d="@\\2";document.write('.$m.');';

        $mask = "<script type=\"text/javascript\">$script</script>".
                "<noscript><em class=\"format-error\">$noscript</em></noscript>";
      }

      return strtr($mask, array('\1' => $user, '\2' => $domain, '\3' => $root));
    }
}
